/*
	Stempora Web Framework
	Copyright (c) 2002-2018 Stempora. 
	All rights reserved.
		web:  www.stempora.com
		mail: support@stempora.com				
*/

var STBBackgrounds = Object.create(STBModule.prototype);


STBBackgrounds.name				= "ModuleBackgrounds";
STBBackgrounds.particlesScript	= site.assets + "plugins/particles.js/plugin.js";
STBBackgrounds.particlesIds		= 0;


STBBackgrounds.initParticlesCallback = function() {
	var particles = $(".background-particles:not(.__done)");

	if (particles.length > 0) {
		var parseParticles = function () {
			var obj = $(this);

			obj.attr("id", "psjs-" + STBBackgrounds.particlesIds);
			particlesJS.load("psjs-" + STBBackgrounds.particlesIds, obj.attr("data-path"));

			STBBackgrounds.particlesIds++;

			obj.addClass("__done");
		};

		particles.each(parseParticles);
	}
}

STBBackgrounds.initParticles = function() {
	var particles = $(".background-particles:not(.__done)");

	if (particles.length > 0) {

		STBUtils.loadScriptCallback(
			STBBackgrounds.particlesScript,
			STBBackgrounds.initParticlesCallback,
			true
		);
	}
}


STBBackgrounds.angleNeedsClass = function(lastclass , needle) {
	if (
		((lastclass == "angle1")	&& (needle.indexOf("angle1") !== -1)) ||
		((lastclass == "angle1")	&& (needle.indexOf("angle3") !== -1)) ||
		((lastclass == "angle1")	&& (needle.indexOf("angle5") !== -1)) ||

		((lastclass == "angle4")	&& (needle.indexOf("angle1") !== -1)) ||
		((lastclass == "angle4")	&& (needle.indexOf("angle3") !== -1)) ||
		((lastclass == "angle4")	&& (needle.indexOf("angle5") !== -1)) ||

		((lastclass == "angle8")	&& (needle.indexOf("angle1") !== -1)) ||
		((lastclass == "angle8")	&& (needle.indexOf("angle3") !== -1)) ||
		((lastclass == "angle8")	&& (needle.indexOf("angle5") !== -1)) ||

		((lastclass == "angle2")	&& (needle.indexOf("angle2") !== -1)) ||
		((lastclass == "angle2")	&& (needle.indexOf("angle4") !== -1)) ||
		((lastclass == "angle2")	&& (needle.indexOf("angle6") !== -1)) ||

		((lastclass == "angle3")	&& (needle.indexOf("angle2") !== -1)) ||
		((lastclass == "angle3")	&& (needle.indexOf("angle4") !== -1)) ||
		((lastclass == "angle3")	&& (needle.indexOf("angle6") !== -1)) ||

		((lastclass == "angle7")	&& (needle.indexOf("angle2") !== -1)) ||
		((lastclass == "angle7")	&& (needle.indexOf("angle4") !== -1)) ||
		((lastclass == "angle7")	&& (needle.indexOf("angle6") !== -1))
	) {
		return true;
	} else {
		return false;
	}
}

STBBackgrounds.angleDisable = function() {
	//remove angle backgrounds
	$(".background-angle").removeClass("background-angle angle1 angle2 angle3 angle4 angle5 angle6 angle7 angle8 has-angle-background");
}

STBBackgrounds.angleExceptions = function() {
	//main and footer angle class
	var main		= $("body > main"),
		mainClass	= main.attr("class"),
		footer		= $("body > footer"),
		footerSection = footer.find("section").first();

	if (main.length && footer.length && footerSection.length) {
		lastclass = STBBackgrounds.angleGetClass(mainClass);

		if (STBBackgrounds.angleNeedsClass(lastclass , footerSection.attr("class"))) {
			footer.addClass("has-angle-background");
		}
	}
}

STBBackgrounds.angleGetClass = function(data) {
	if (data.indexOf("angle1") != -1) return "angle1";
	if (data.indexOf("angle2") != -1) return "angle2";
	if (data.indexOf("angle3") != -1) return "angle3";
	if (data.indexOf("angle4") != -1) return "angle4";
	if (data.indexOf("angle5") != -1) return "angle5";
	if (data.indexOf("angle6") != -1) return "angle6";
	if (data.indexOf("angle7") != -1) return "angle7";
	if (data.indexOf("angle8") != -1) return "angle8";
}

STBBackgrounds.initVideos = function() {

	$('[data-vide-bg]:not(.__done)').each(function(i, element) {
		var $element = $(element),
			options = $element.data('vide-options'),
			path = $element.data('vide-bg');


		$element['vide'](path, options);
		$element.addClass("__done");

    });
}

STBBackgrounds.menuRemoveEffects = function () {
	var header = $("header");

	if (header.hasClass("with-background")) {
		var bg = header.find(".background");

		if (bg.hasClass("background-transparent")) {
			header.parent().addClass("header-no-shadow");
		}
	}
}

STBBackgrounds.initSliders = function() {
	var bgs = $(".background-slider:not(.__done)");

	if (!bgs.length){
		return true;
	}

	bgs.each(function() {

		var bg			= $(this),
			images		= JSON.parse(bg.attr("data-images")),
			trans		= bg.attr("data-transition"),
			transDur	= bg.attr("data-traisition-duration"),
			duration	= bg.attr("data-duration");
		
		bg.backstretch(
			images, 
			{
				transition			: trans , 
				transitionDuration	: transDur, 
				duration			: duration
			}
		);			

		bg.addClass("__done");

	});
}


STBBackgrounds.initYoutube = function() {
	var bgs = $(".background-youtube:not(.__done)");

	if (!bgs.length){
		return true;
	}

	bgs.each(function() {
		var bg			= $(this),
			container	= $(this).find(".background-youtube-content"),
			youtube		= bg.attr("data-video"),
			startPoint	= bg.attr("data-start"),
			volume		= bg.attr("data-volume");

		container.YTPlayer({
			videoId			: youtube,
			fitToBackground	: true,
			mute			: false,
			playerVars		: {
				modestbranding	: 0,
				autoplay		: 1,
				controls		: 0,
				showinfo		: 0,
				branding		: 0,
				rel				: 0,
				autohide		: 0,
				start			: startPoint
			},
			callback: function() {
				var player = container.data('ytPlayer').player;				
				player.setVolume(volume);
			}
		});
		bg.addClass("__done");
	});

}

STBBackgrounds.runOnReady = function() {
	STBBackgrounds.initVideos();
	STBBackgrounds.initParticles();
	STBBackgrounds.initSliders();
	STBBackgrounds.initYoutube();

	STBBackgrounds.menuRemoveEffects();

	if (!site.onepage) {
		STBBackgrounds.angleExceptions();
	}
}

STBBackgrounds.runOnContentUpdate = function() {
	STBBackgrounds.initVideos();
	STBBackgrounds.initParticles();
	STBBackgrounds.initSliders();
	STBBackgrounds.initYoutube();
}

site.registerModule(STBBackgrounds);